csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure S2 - Demographics figure/CSV/'
figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure S2 - Demographics figure/Figure components/'

# Ritthem natural oyster reef -----------------------
par(mfrow = c(1,1))

setwd(csvDirectory)
d = read.csv('Ritthem natural oyster reef.csv')
d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
d$mass.g[d$species == 'C. gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'C. gigas' & !is.na(d$length.mm)] ^2.84053

filter = T
n_samples = length(unique(d$sample.ID[filter]))
sampleArea.m2 = unique(d$sampleArea[filter])
breaks = seq(-10,10, 0.2)

filterOyster = filter & d$species == 'C. gigas' 
oysterBiomass.g = hist(log(d$mass.g[filterOyster]),
                       breaks = breaks, plot = F)$counts
oysterBiomass.g_m2 = oysterBiomass.g/(n_samples*sampleArea.m2)
filterMussel = filter & d$species == 'Mytilus edulis'
musselBiomass.g = hist(log(d$mass.g[filterMussel]),
                       breaks = breaks, plot = F)$counts
musselBiomass.g_m2 = musselBiomass.g/(n_samples*sampleArea.m2)

# Plot 
tiff('Figure S2a.tiff', width = 20, height = 15, units = "cm", res = 300)
library(scales)
ylim = 150
par(mar = c(5,5,4,4))
plot(c(1), type = 'n', xlim = range(breaks),
     ylim = c(0,ylim), bty = 'n', ylab = '', xlab = 'Mass (g)',
     xaxt = 'n', main = 'Natural oyster reef', cex.lab = 1.4, cex.axis = 1.4)
axis(side = 1, labels = 10^seq(-4,4,1), at = log(10^seq(-4,4,1)), cex.axis = 1.4)
axis(side = 2, line = 1.5, at = ylim/2, tick = F, labels = expression('Individual density (ind m'^-2*')'), cex.axis = 1.4)
axis(side = 2, labels = ylim, at = ylim, tick = F, font = 2, cex.axis = 1.4)
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = oysterBiomass.g_m2, lty = 0, col = alpha('red',0.5))
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = musselBiomass.g_m2, lty = 0, col = alpha('blue',0.5))
lineSeq = 10^seq(-5,5,1)
for(i in 1:length(lineSeq)){
  x = lineSeq[i]
  lines(y = c(0,1150), x = log(c(x,x)), col = alpha('black',0.7), lwd = 1, lty = 2)
}
setwd(figureDirectory)
dev.off()

# --------------------------------------

# BESE Transects

setwd(csvDirectory)
d = read.csv("bivalve_transect_data_complete.csv")
d = d[d$species == 'Mytilus edulis' | d$species == 'Crassostrea gigas',]
d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053
d = d[d$date_harvest != '2018-10-25' | d$site != 'Viane',]

oysterBiomass.g_m2 = musselBiomass.g_m2 = rep(0, times = 100)
counter = 0
for(i_site in  c("Paulina","Viane")){
  for(i_transect in sort(unique(d$transect_position))){
    filter = d$site == i_site & d$transect_position == i_transect
    if(sum(filter > 0)){
      n_samples = length(unique(d$transect_position[filter]))
      sampleArea.m2 = sort(unique(d$sampleArea.m2[filter]))
      breaks = seq(-10,10, 0.2)
      
      filterOyster = filter & d$species == 'Crassostrea gigas' 
      oysterBiomass.g = hist(log(d$mass.g[filterOyster]),
                             breaks = breaks, plot = F)$counts
      oysterBiomass.g_m2 = oysterBiomass.g_m2 + oysterBiomass.g/(n_samples*sampleArea.m2)
      filterMussel = filter & d$species == 'Mytilus edulis'
      musselBiomass.g = hist(log(d$mass.g[filterMussel]),
                             breaks = breaks, plot = F)$counts
      musselBiomass.g_m2 = musselBiomass.g_m2 + musselBiomass.g/(n_samples*sampleArea.m2)
      counter = counter + 1
    }
  }
}
oysterBiomass.g_m2 = oysterBiomass.g_m2/counter
musselBiomass.g_m2 = musselBiomass.g_m2/counter

# Plot 
tiff('Figure S2c.tiff', width = 20, height = 15, units = "cm", res = 300)
ylim = 150
par(mar = c(5,5,4,4))
plot(c(1), type = 'n', xlim = range(breaks), 
     ylim = c(0,ylim), bty = 'n', ylab = '', xlab = 'Mass (g)',
     xaxt = 'n', main = 'Lattice structures', cex.axis = 1.4, cex.lab = 1.4)
axis(side = 1, labels = 10^seq(-4,4,1), at = log(10^seq(-4,4,1)), cex.axis = 1.4)
axis(side = 2, line = 1.5, at = ylim/2, tick = F, labels = expression('Individual density (ind m'^-2*')'), cex.axis = 1.4)
axis(side = 2, labels = ylim, at = ylim, tick = F, font = 2, cex.axis = 1.4)
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = oysterBiomass.g_m2, lty = 0, col = alpha('red',0.5))
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = musselBiomass.g_m2, lty = 0, col = alpha('blue',0.5))
lineSeq = 10^seq(-5,5,1)
for(i in 1:length(lineSeq)){
  x = lineSeq[i]
  lines(y = c(0,1150), x = log(c(x,x)), col = alpha('black',0.7), lwd = 1, lty = 2)
}

setwd(figureDirectory)
dev.off()

# Bivalve survey  (Seagrass mimics) ---------------------------
setwd(csvDirectory)
d = read.csv('Bivalve survey all marshes with AHN inundation.csv')
d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053

habitat = 'seagrass mimic'
breaks = seq(-10,10, 0.2)
oysterBiomass.g_m2 = musselBiomass.g_m2 = rep(0, times = 100)
counter = 0
for(i_site in  c("Paulina","Ritthem")){
  filter = d$habitat == habitat & d$site == i_site
  n_samples = length(unique(d$sample.ID[filter]))
  sampleArea.m2 = unique(d$sampleArea.m2[filter])
  filterOyster = filter & d$species == 'Crassostrea gigas' 
  oysterBiomass.g = hist(log(d$mass.g[filterOyster]),
                         breaks = breaks, plot = F)$counts
  oysterBiomass.g_m2 = oysterBiomass.g_m2 + oysterBiomass.g/(n_samples*sampleArea.m2)
  filterMussel = filter & d$species == 'Mytilus edulis'
  musselBiomass.g = hist(log(d$mass.g[filterMussel]),
                         breaks = breaks, plot = F)$counts
  musselBiomass.g_m2 = musselBiomass.g_m2 + musselBiomass.g/(n_samples*sampleArea.m2)
  counter = counter + 1
}
oysterBiomass.g_m2 = oysterBiomass.g_m2/counter
musselBiomass.g_m2 = musselBiomass.g_m2/counter

# Plot 
tiff('Figure S2b.tiff', width = 20, height = 15, units = "cm", res = 300)
ylim = 15
par(mar = c(5,5,4,4))
plot(c(1), type = 'n', xlim = range(breaks),
     ylim = c(0,ylim), bty = 'n', ylab = '', xlab = 'Mass (g)',
     xaxt = 'n', main = 'Seagrass mimics', cex.lab = 1.4, cex.lab = 1.4, cex.axis = 1.4)
axis(side = 1, labels = 10^seq(-4,4,1), at = log(10^seq(-4,4,1)), cex.axis = 1.4)
axis(side = 2, line = 1.5, at = ylim/2, tick = F, labels = expression('Individual density (ind m'^-2*')'), cex.axis = 1.4)
axis(side = 2, labels = ylim, at = ylim, tick = F, font = 2, cex.axis = 1.4)
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = oysterBiomass.g_m2, lty = 0, col = alpha('red',0.5))
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = musselBiomass.g_m2, lty = 0, col = alpha('blue',0.5))
lineSeq = 10^seq(-5,5,1)
for(i in 1:length(lineSeq)){
  x = lineSeq[i]
  lines(y = c(0,1150), x = log(c(x,x)), col = alpha('black',0.7), lwd = 1, lty = 2)
}
setwd(figureDirectory)
dev.off()


# Bivalve survey  (Salt marsh) ---------------------------
setwd(csvDirectory)
d = read.csv('Bivalve survey all marshes with AHN inundation.csv')
d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053

habitat = 'salt marsh'
filter = d$habitat == habitat
n_samples = length(unique(d$sample.ID[filter]))
sampleArea.m2 = sort(unique(d$sampleArea.m2[filter]))[1]
breaks = seq(-10,10, 0.2)

filterOyster = filter & d$species == 'Crassostrea gigas' 
oysterBiomass.g = hist(log(d$mass.g[filterOyster]),
                       breaks = breaks, plot = F)$counts
oysterBiomass.g_m2 = oysterBiomass.g/(n_samples*sampleArea.m2)
filterMussel = filter & d$species == 'Mytilus edulis'
musselBiomass.g = hist(log(d$mass.g[filterMussel]),
                       breaks = breaks, plot = F)$counts
musselBiomass.g_m2 = musselBiomass.g/(n_samples*sampleArea.m2)

# Plot 
tiff('Figure S2d.tiff', width = 20, height = 15, units = "cm", res = 300)
par(mar = c(5,5,4,4))
ylim  = 1.5
plot(c(1), type = 'n', xlim = range(breaks),
     ylim = c(0,ylim), bty = 'n', ylab = '', xlab = 'Mass (g)',
     xaxt = 'n', main = 'Salt marsh reef', cex.lab = 1.4, cex.axis = 1.4)
axis(side = 1, labels = 10^seq(-4,4,1), at = log(10^seq(-4,4,1)), cex.axis = 1.4)
axis(side = 2, line = 1.5, at = ylim/2, tick = F, labels = expression('Individual density (ind m'^-2*')'),  cex.axis = 1.4)
axis(side = 2, labels = ylim, at = ylim, tick = F, font = 2, cex.axis = 1.4)
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = oysterBiomass.g_m2, lty = 0, col = alpha('red',0.5))
rect(xleft = breaks[1:(length(breaks)-1)], xright = breaks[2:length(breaks)],
     ybottom = 0, ytop = musselBiomass.g_m2, lty = 0, col = alpha('blue',0.5))
lineSeq = 10^seq(-5,5,1)
for(i in 1:length(lineSeq)){
  x = lineSeq[i]
  lines(y = c(0,1150), x = log(c(x,x)), col = alpha('black',0.7), lwd = 1, lty = 2)
}
setwd(figureDirectory)
dev.off()
